//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Controls 1.0

VirtualKey {
    id : symbolKey

    property var keyboard

    property var symbols
    property int symbolIndex : 0

    readonly property string symbol : symbols[symbolIndex].symbol

    Text {
        id : letter

        anchors {
            centerIn : parent
        }
        font {
            family    : "Lato"
            weight    : Font.Light
            pixelSize : 32
        }
        text : parent.symbol
        color : highlight ? "white" : "#5F5F5F"

        Behavior on color {
            ColorAnimation { duration : 70 }
        }

        Behavior on text {
            SequentialAnimation {
                NumberAnimation {
                    target   : letter
                    duration : 200
                    property : "opacity"
                    to        : 0
                }
                PropertyAction { property : "text" }
                NumberAnimation {
                    target   : letter
                    duration : 200
                    property : "opacity"
                    to        : 1
                }
            }
        }
    }
    onClicked : keyboard.triggerKeyEvent(
                    symbols[symbolIndex].keyCode, symbol)
}
